/******************************************************************************
* This file contains the declarations for different data used in FSL Profile.
*
* Copyright (c) 2008, Freescale, Inc.  All rights reserved.
*
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from  Freescale Semiconductor.
*
******************************************************************************/

#include "EmbeddedTypes.h"
#include "NwkGlobals.h"
#include "ZRCProfileGlobals.h"
#include "ZRCProfileCommands.h"
#include "ZRCProfileInterface.h"


/******************************************************************************
*******************************************************************************
* Private Macros
*******************************************************************************
******************************************************************************/

/******************************************************************************
*******************************************************************************
* Public memory declarations
*******************************************************************************
******************************************************************************/

/* Zrc attributes data */
zrcAttrData_t gZrcAttr ={
                        gDefaultKeyRepeatInterval_c,
                        gDefaultKeyRepeatWaitTime_c,
                        gDefaultExTransferCount_c,
                        gDefaultReceiveKeyRepeatCnf_c
                       };


/* The Task Id for ZRC Profile */
tsTaskID_t gZRCProfileTaskID_c;

/* The ZRC commands supported bit map specifies which user control
   commands are suported */
CONST uint8_t gaZRCCmdSupportedBitMap[gCmdsSupportedFieldLength_c] = gZRC_CmdSupportedBitMap_c;



/******************************************************************************
*******************************************************************************
* Private Macros
*******************************************************************************
******************************************************************************/
/****************************************************************************/
